VERSION 5.00
Begin VB.Form Terminal 
   Caption         =   "Proteus TCPIP Terminal"
   ClientHeight    =   6900
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6420
   LinkTopic       =   "Form1"
   ScaleHeight     =   6900
   ScaleWidth      =   6420
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton Send 
      Caption         =   "Send"
      Height          =   375
      Left            =   5490
      TabIndex        =   7
      Top             =   5625
      Width           =   780
   End
   Begin VB.Frame Frame1 
      Caption         =   "Communication"
      Height          =   1905
      Left            =   135
      TabIndex        =   3
      Top             =   315
      Width           =   6090
      Begin VB.TextBox ComPort 
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   315
         Left            =   2565
         TabIndex        =   12
         Text            =   "1"
         Top             =   1440
         Width           =   285
      End
      Begin VB.TextBox IPAddress 
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "###.###.###.###"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   0
         EndProperty
         Height          =   315
         Left            =   2205
         TabIndex        =   10
         Text            =   "10.10.6.101"
         Top             =   855
         Width           =   1200
      End
      Begin VB.CommandButton Disconnect 
         Caption         =   "Disconnect"
         Height          =   420
         Left            =   4545
         TabIndex        =   9
         Top             =   1080
         Width           =   1275
      End
      Begin VB.CommandButton Connect 
         Caption         =   "Connect"
         Height          =   420
         Left            =   4545
         TabIndex        =   8
         Top             =   540
         Width           =   1275
      End
      Begin VB.OptionButton SelectRS232 
         Caption         =   "RS-232"
         Height          =   285
         Left            =   810
         TabIndex        =   6
         Top             =   1440
         Width           =   870
      End
      Begin VB.OptionButton SelectTCPIP 
         Caption         =   "TCPIP"
         Height          =   285
         Left            =   810
         TabIndex        =   5
         Top             =   900
         Width           =   825
      End
      Begin VB.OptionButton SelectUSB 
         Caption         =   "USB"
         Height          =   285
         Left            =   810
         TabIndex        =   4
         Top             =   360
         Value           =   -1  'True
         Width           =   1140
      End
      Begin VB.Line Line2 
         X1              =   675
         X2              =   3735
         Y1              =   720
         Y2              =   720
      End
      Begin VB.Line Line1 
         X1              =   675
         X2              =   3735
         Y1              =   1260
         Y2              =   1260
      End
      Begin VB.Label Label3 
         Caption         =   "Com Port"
         Height          =   195
         Left            =   1845
         TabIndex        =   13
         Top             =   1485
         Width           =   690
      End
      Begin VB.Label Label2 
         Caption         =   "IPA"
         Height          =   195
         Left            =   1350
         TabIndex        =   11
         Top             =   900
         Width           =   330
      End
   End
   Begin VB.TextBox LogWindow 
      BeginProperty Font 
         Name            =   "Courier"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3195
      Left            =   135
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   2
      Top             =   2295
      Width           =   6135
   End
   Begin VB.CommandButton CloseTerminal 
      Caption         =   "Close"
      Height          =   555
      Left            =   2415
      TabIndex        =   1
      Top             =   6195
      Width           =   1755
   End
   Begin VB.TextBox CommandLine 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   135
      TabIndex        =   0
      Top             =   5640
      Width           =   5190
   End
End
Attribute VB_Name = "Terminal"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public TCPIPAddress As String
Public TCPIPPort As String
Public ConnectionState As Integer
Public crStr As String
Public handle As Long
  
Private Sub addLogLine(aLine As String)
    Dim str As String
    Dim myStr As String
    Dim cc As String
    Dim ci, i As Integer
    Dim lineCounter As Integer
    
    
    myStr = ""
    For i = 1 To Len(aLine)
        cc = Mid(aLine, i, 1)
        ci = Asc(cc)
        If (ci = 13) Then
            myStr = myStr + Chr(13) + Chr(10)
        ElseIf (ci <> 4) Then '*** 4 is EOT
            myStr = myStr + cc
        End If
    Next i
    
    If Len(myStr) > 0 Then
        str = LogWindow.Text
        lineCounter = lineCounter + 1
        If (lineCounter > 5000) Then
            lineCounter = 5000
            For i = 1 To Len(str)
                cc = Mid(str, i, 1)
                If (Asc(cc) = 10) Then
                    myStr = Mid(str, i + 1, Len(str) - (i))
                    i = Len(str)
                End If
            Next i
            str = myStr
        End If
        LogWindow.Text = str + myStr
        str = LogWindow.Text
        LogWindow.SelStart = Len(str)
    End If
End Sub
Private Sub CloseTerminal_Click()
Unload Me
End Sub
Private Sub CommandLine_KeyDown(KeyCode As Integer, Shift As Integer)
        
    If KeyCode = 13 Then
        Call Send_Click
    End If
End Sub


Private Sub Connect_Click()
    Dim comStr As String
    Dim portStr As String
    
    If (ConnectionState > 0) Then
        If (ConnectionState = 1) Then
            MsgBox ("Already connected to USB!")
        ElseIf ConnectionState = 2 Then
            MsgBox ("Already connected to TCPIP!")
        ElseIf ConnectionState = 3 Then
            MsgBox ("Already connected to RS-232!")
        Else
            MsgBox ("Already connected to unknown!")
        End If
    Else
        If (SelectUSB.Value = True) Then
            handle = fnProteusComOpen(1, 1, "")
            If (handle > 0) Then
                addLogLine ("Connection to Proteus USB Done!" + crStr)
                ConnectionState = 1
            Else
                addLogLine ("Error on Connection to Proteus USB!" + crStr)
                MsgBox ("Cannot open Proteus USB!")
            End If
        ElseIf (SelectTCPIP.Value = True) Then
            handle = fnProteusComOpen(2, 0, IPAddress)
            If (handle > 0) Then
                addLogLine ("Connection to Proteus TCPIP Done!" + crStr)
                ConnectionState = 2
            Else
                addLogLine ("Error on Connection to Proteus TCPIP!" + crStr)
                MsgBox ("Cannot open Proteus TCPIP!")
            End If
        ElseIf (SelectRS232.Value = True) Then
            portStr = ComPort
            comStr = "COM" + portStr
            handle = fnProteusComOpen(3, 0, comStr)
            If (handle > 0) Then
                addLogLine ("Connection to Proteus RS-232 Done!" + crStr)
                ConnectionState = 3
            Else
                addLogLine ("Error on Connection to Proteus RS-232!" + crStr)
                MsgBox ("Cannot open Proteus RS-232!")
            End If
        End If
    End If
    CommandLine.SetFocus
           
End Sub

Private Sub Disconnect_Click()
    Dim ret As Boolean
    
    If ConnectionState > 0 Then
        ret = fnProteusComClose(ConnectionState, handle)
        ConnectionState = 0
        If (ret <> False) Then
            addLogLine ("Disconnect Done!" + crStr)
        Else
            addLogLine ("Error in Disconnect!" + crStr)
        End If
    Else
        MsgBox ("Not Connected!")
    End If
End Sub

Private Sub Form_Load()
    ConnectionState = 0
    crStr = Chr(13)
    
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Dim ret As Boolean
    If (ConnectionState > 0) Then
        ret = fnProteusComClose(ConnectionState, handle)
    End If
End Sub

Private Sub LogWindow_KeyPress(KeyAscii As Integer)
    CommandLine.SetFocus
End Sub

Private Sub Send_Click()
    Dim sendStr() As Byte
    Dim ReplyBuffer() As Byte
    Dim cc As String
    Dim i As Integer
    Dim j As Integer
    Dim ret As Boolean
    Dim myStr As String
    Dim cmdStr As String
    Dim whichOne As Integer
    Dim ccValue As Integer
    
    
    ReDim sendStr(255)
    ReDim ReplyBuffer(6000)
                
        
        If (ConnectionState > 0) Then
            myStr = CommandLine
            cmdStr = ""
            For i = 1 To Len(myStr)
                cc = Mid(myStr, i, 1)
                ccValue = Asc(cc)
                If (ccValue = 13) Then
                    GoTo GOTCR
                Else
                    cmdStr = cmdStr + cc
                End If
            Next i
GOTCR:
            cmdStr = cmdStr + Chr(13)
    
            For i = 1 To Len(cmdStr)
                cc = Mid(cmdStr, i, 1)
                sendStr(i - 1) = Asc(cc)
            Next i
            sendStr(i) = 0
        
            whichOne = 1
            
            ret = fnProteusComSendRecv(ConnectionState, handle, sendStr(0), ReplyBuffer(0))
            
            If ret = False Then
                myStr = "Error in Send Receive!" + crStr
            Else
                myStr = ""
                j = 0
                Do
                    cc = Chr(ReplyBuffer(j))
                    ccValue = Asc(cc)
                    If (ccValue = 0) Then
                        GoTo EndLoop
                    Else
                        myStr = myStr + cc
                    End If
                    j = j + 1
EndLoop:
                Loop Until (ccValue = 0)
                
            End If
        Else
            myStr = "Not connected!" + crStr
        End If
        addLogLine (myStr)
        CommandLine = ""
        CommandLine.SetFocus
End Sub
